<?php
/***************************************************************************
 *						Theme Modules
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 * 
 *  					Copyright (C) Themify
 * 						https://themify.me
 *
 *  To add custom modules to the theme, create a new 'custom-modules.php' file in the theme folder.
 *  They will be added to the theme automatically.
 * 
 ***************************************************************************/

/**
 * Default Index Layout Module
 * @param array $data Theme settings data
 * @return string Markup for module.
 * @since 1.0.0
 */
function themify_default_layout( $data = array() ){
	$data = themify_get_data();
	/**
	 * Theme Settings Option Key Prefix
	 * @var string
	 */
	$prefix = 'setting-default_';

	if ( themify_get( $prefix . 'more_text' ) == '' ) {
		$more_text = __('More', 'themify');
	} else {
		$more_text = themify_get( $prefix.'more_text' );
	}
	/**
	 * Tertiary options <blank>|yes|no
	 * @var array
	 */
	$default_options = array(
		array('name' => '', 'value' => ''),
		array('name' => __('Yes', 'themify'), 'value' => 'yes'),
		array('name' => __('No', 'themify'), 'value' => 'no')
	);
	/**
	 * Post content display options
	 * @var array
	 */
	$default_display_options = array(
		array('name' => __('Full Content', 'themify'),'value' => 'content'),
		array('name' => __('Excerpt', 'themify'),'value' => 'excerpt'),
		array('name' => __('None', 'themify'),'value' => 'none')
	);
	/**
	 * Post layout options
	 * @var array
	 */
	$default_post_layout_options = array(
		array('value' => 'list-post', 'img' => 'images/layout-icons/list-post.png', 'title' => __('List Post', 'themify')),
		array('value' => 'grid4', 'img' => 'images/layout-icons/grid4.png', 'title' => __('Grid 4', 'themify')),
		array('value' => 'grid3', 'img' => 'images/layout-icons/grid3.png', 'title' => __('Grid 3', 'themify')),
		array('value' => 'grid2', 'img' => 'images/layout-icons/grid2.png', 'title' => __('Grid 2', 'themify')),
		array('value' => 'zig-zag', 'img' => 'images/layout-icons/zig-zag.png', 'title' => __('Zig-Zag', 'themify'), 'selected' => true),
	);
	/**
	 * Sidebar placement options
	 * @var array
	 */
	$sidebar_location_options = array(
		array('value' => 'sidebar1', 'img' => 'images/layout-icons/sidebar1.png', 'selected' => true, 'title' => __('Sidebar Right', 'themify')),
		array('value' => 'sidebar1 sidebar-left', 'img' => 'images/layout-icons/sidebar1-left.png', 'title' => __('Sidebar Left', 'themify')),
		array('value' => 'sidebar-none', 'img' => 'images/layout-icons/sidebar-none.png', 'title' => __('No Sidebar', 'themify'))
	);
	/**
	 * Image alignment options
	 * @var array
	 */
	$alignment_options = array(
		array('name' => '', 'value' => ''),
		array('name' => __('Left', 'themify'), 'value' => 'left'),
		array('name' => __('Right', 'themify'), 'value' => 'right')
	);

	/**
	 * Module markup
	 * @var string
	 */
	$output = '<div class="themify-info-link">' . __( 'Here you can set the <a href="https://themify.me/docs/default-layouts">Default Layouts</a> for WordPress archive post layout (category, search, archive, tag pages, etc.), single post layout (single post page), and the static Page layout. The default single post and page layout can be override individually on the post/page > edit > Themify Custom Panel.', 'themify' ) . '</div>';
	
	/**
	 * Index Sidebar Option
	 */
	$output .= '<p>
					<span class="label">' . __('Archive Sidebar Option', 'themify') . '</span>';
	$val = themify_get( $prefix.'layout' );
	foreach ( $sidebar_location_options as $option ) {
		if ( ( '' == $val || ! $val || ! isset( $val ) ) && ( isset( $option['selected'] ) && $option['selected'] ) ) {
			$val = $option['value'];
		}
		if ( $val == $option['value'] ) {
			$class = 'selected';
		} else {
			$class = '';
		}
		$output .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI.'/'.$option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
	}
	
	$output .= '	<input type="hidden" name="' . esc_attr( $prefix ) . 'layout" class="val" value="' . esc_attr( $val ) . '" />
				</p>';

	/**
	 * Post Layout
	 */
	$output .= '<p>
					<span class="label">' . __('Post Layout', 'themify') . '</span>';
	$val = themify_get( $prefix.'post_layout' );
	foreach ( $default_post_layout_options as $option ) {
		if ( ( '' == $val || ! $val || ! isset( $val ) ) && ( isset( $option['selected'] ) && $option['selected'] ) ) {
			$val = $option['value'];
		}
		if ( $val == $option['value'] ) {
			$class = 'selected';
		} else {
			$class = '';
		}
		$output .= '<a href="#" class="preview-icon ' . esc_attr( $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI.'/'.$option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
	}
	
	$output .= '	<input type="hidden" name="' . esc_attr( $prefix ) . 'post_layout" class="val" value="' . esc_attr( $val ) . '" />
				</p>';

	/**
	 * Display Content
	 */
	$output .= '<p>
					<span class="label">' . __('Display Content', 'themify') . '</span> 
					<select name="'.$prefix.'layout_display">'.
						themify_options_module($default_display_options, $prefix.'layout_display').'
					</select>
				</p>';

	/**
	 * Excerpt length
	 */
	$output .= '<p style="display:none">
					<span class="pushlabel vertical-grouped">
						<label>
							<input class="width2" type="text" value="' . ( isset( $data[ $prefix . 'excerpt_length' ] ) ? esc_attr( $data[ $prefix . 'excerpt_length' ] ) : '' ) . '" name="' . esc_attr( $prefix ) . 'excerpt_length"> '
							. __( 'Excerpt length (enter number of words)', 'themify' ) . '
						</label>
					</span>
				</p>';
				
   /**
     * Enable Masonry
     */
    $output .= '<p data-show-if-element="[name=setting-default_post_layout]" data-show-if-value=' . '["grid2","grid3","grid4"]' . '>
					<span class="label">' . __('Post Masonry', 'themify') . '</span>
					<select name="setting-disable_masonry">' .
            themify_options_module($default_options, 'setting-disable_masonry') . '
					</select>
				</p>';
	
	/**
     * Post Gutter
     */
    $output .= '<p data-show-if-element="[name=setting-default_post_layout]" data-show-if-value=' . '["grid2","grid3","grid4"]' . '>
					<span class="label">' . __('Post Gutter', 'themify') . '</span>
					<select name="setting-post_gutter">' .
            themify_options_module(array(
                array('name' => __('Default', 'themify'), 'value' => 'gutter'),
                array('name' => __('No gutter', 'themify'), 'value' => 'no-gutter')
                    ), 'setting-post_gutter') . '
					</select>
				</p>';
	
	/**
	 * More Text
	 */
	$output .= '<p>
					<span class="label">' . __('More Text', 'themify') . '</span>
					<input type="text" name="'.$prefix.'more_text" value="'.$more_text.'">
				</p>';

	/**
	 * Display more link in excerpt mode
	 */
	$output .= '<span class="pushlabel vertical-grouped"><label for="setting-excerpt_more"><input type="checkbox" value="1" id="setting-excerpt_more" name="setting-excerpt_more" '.checked(themify_get( 'setting-excerpt_more' ), 1, false).'/> ' . __('Display more link button in excerpt mode as well.', 'themify') . '</label></span>';

	/**
	 * Order & OrderBy Options
	 */
	$output .= themify_post_sorting_options('setting-index_order', $data);
				
	/**
	 * Hide Post Title
	 */
	$output .= '<p>
					<span class="label">' . __('Hide Post Title', 'themify') . '</span>
					<select name="'.$prefix.'post_title">' .
						themify_options_module($default_options, $prefix.'post_title') . '
					</select>
				</p>';
	
	/**
	 * Unlink Post Title
	 */
	$output .= '<p>
					<span class="label">' . __('Unlink Post Title', 'themify') . '</span>
					<select name="'.$prefix.'unlink_post_title">' .
						themify_options_module($default_options, $prefix.'unlink_post_title') . '
					</select>
				</p>';
	
	/**
	 * Hide Post Meta
	 */
	$output .= themify_post_meta_options($prefix.'post_meta', $data);
	
	/**
	 * Hide Post Date
	 */
	$output .= '<p>
					<span class="label">' . __('Hide Post Date', 'themify') . '</span>
					<select name="'.$prefix.'post_date">' .
						themify_options_module($default_options, $prefix.'post_date') . '
					</select>
				</p>';
	
	/**
	 * Auto Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Auto Featured Image', 'themify') . '</span>
					<label for="setting-auto_featured_image"><input type="checkbox" value="1" id="setting-auto_featured_image" name="setting-auto_featured_image" '.checked( themify_get( 'setting-auto_featured_image' ), 1, false).'/> ' . __('If no featured image is specified, display first image in content.', 'themify') . '</label>
				</p>';
	
	
	/**
	 * Hide Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Hide Featured Image', 'themify') . '</span>
					<select name="'.$prefix.'post_image">' .
						themify_options_module($default_options, $prefix.'post_image') . '
					</select>
				</p>';
	
	/**
	 * Unlink Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Unlink Featured Image', 'themify') . '</span>
					<select name="'.$prefix.'unlink_post_image">' .
						themify_options_module($default_options, $prefix.'unlink_post_image') . '
					</select>
				</p>';
	
	/**
	 * Featured Image Sizes
	 */
	$output .= themify_feature_image_sizes_select('image_post_feature_size');
	
	/**
	 * Image Dimensions
	 */	
	$output .= '<p>
					<span class="label">' . __('Image Size', 'themify') . '</span>  
					<input type="text" class="width2" name="setting-image_post_width" value="'.themify_get( 'setting-image_post_width' ).'" /> ' . __('width', 'themify') . ' <small>(px)</small>
					<input type="text" class="width2" name="setting-image_post_height" value="'.themify_get( 'setting-image_post_height' ).'" /> ' . __('height', 'themify') . ' <small>(px)</small>
					<br /><span class="pushlabel"><small>' . __('Enter height = 0 to disable vertical cropping with img.php enabled', 'themify') . '</small></span>
				</p>';
	
	return $output;
}



if ( ! function_exists( 'themify_exclude_rss' ) ) {
	/**
	 * Exclude RSS
	 * @return string
	 */
	function themify_exclude_rss() {
		return '<p><label for="setting-exclude_rss"><input type="checkbox" id="setting-exclude_rss" name="setting-exclude_rss" ' . checked( themify_get( 'setting-exclude_rss' ), 'on', false ) . '/> ' . __( 'Check here to exclude RSS icon/button in the header', 'themify' ) . '</label></p>';	
	}
}

if ( ! function_exists( 'themify_exclude_search_form' ) ) {
	/**
	 * Exclude Search Form
	 * @return string
	 */
	function themify_exclude_search_form() {
		return '<p><label for="setting-exclude_search_form"><input type="checkbox" id="setting-exclude_search_form" name="setting-exclude_search_form" ' . checked( themify_get( 'setting-exclude_search_form' ), 'on', false ) . '/> ' . __( 'Check here to exclude search form in the header', 'themify' ) . '</label></p>';	
	}
}



if (!function_exists('themify_pagination_infinite')) {

	/**
	 * Choose pagination or infinite scroll
	 * @param array $data
	 * @return string
	 */
	function themify_pagination_infinite($data = array()) {

		$output = '<p><span class="label">' . __( 'Pagination Option', 'themify' ) . '</span>';
		$seetings_more = themify_get( 'setting-more_posts' );

		//Infinite Scroll
		
		$output.= '<label><input ' . checked( $seetings_more ? $seetings_more : 'infinite', 'infinite', false ) . ' type="radio" name="setting-more_posts" value="infinite" />';
		$output.= __('Infinite Scroll', 'themify');
		$output.='</label>';
		
		
		//Load More Button
		$output.= '<label><input ' . checked($seetings_more , 'button', false ) . ' type="radio" name="setting-more_posts" value="button" />';
		$output.= __('Load More Button', 'themify');
		$output.='</label>';
		
		
		//Numbered pagination
		$output.= '<label><input ' . checked( $seetings_more, 'pagination', false ) . ' type="radio" name="setting-more_posts" value="pagination" />';
		$output.= __('Standard Pagination', 'themify') . '</label>';
		$output.= '</p>';

		$output .= '<div class="pushlabel disable-autoinfinite" data-show-if-element="[name=setting-more_posts]:checked" data-show-if-value=\'["infinite", "button"]\'>';
		$output .= '<label for="setting-infinite-url"><input type="checkbox" id="setting-infinite-url" name="setting-infinite-url" '.checked( themify_get( 'setting-infinite-url' ), 'on', false ).'/> ' . __('Disable page number updates on address URL on scrolling', 'themify').'</label>';
		$output .= '</div>';
		$output .= '<br/>';
		
		$output.='<span class="pushlabel"><small>';
		$output.=__('Infinite scroll will auto load posts on scroll. Load more button will load posts when button is clicked. Number pagination will show a regular page navigation.','themify');
		$output.='</small></span>';
		return $output;
	
	}

}

if( ! function_exists( 'themify_header_design' ) ) {
/**
 * Header Design
 * @return string
 */
function themify_header_design() {
	$prefix = 'setting-';
	$header_design = themify_theme_header_design_options();
	unset($header_design[0]);
	$header_design[1]['selected'] = true;
	$menu_style_options = array(
		array('name' => __('Overlay Menu','themify'), 'value' => 'overlay-menu'),
		array('name' => __('Horizontal Menu', 'themify'), 'value' => 'horizontal-menu'),
	);
	
	$output = '<p>
					<span class="label">' . __('Header Design', 'themify') . '</span>';
	$val = themify_get( $prefix.'header_design' );
	foreach ( $header_design as $option ) {
		if ( ( '' == $val || ! $val || ! isset( $val ) ) && ( isset( $option['selected'] ) && $option['selected'] ) ) {
			$val = $option['value'];
		}
		if ( $val == $option['value'] ) {
			$class = 'selected';
		} else {
			$class = '';
		}
		$output .= '<a href="#" class="preview-icon ' .$class. '" title="' . esc_attr( $option['title'] ) . '"><img src="' . THEME_URI.'/'.$option['img'] . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
	}
	
	$output .= '	<input type="hidden" name="' .  $prefix . 'header_design" class="val" value="' . esc_attr( $val ) . '" />
				</p>';
	$output.= '<p  data-show-if-element="[name=setting-header_design]" data-show-if-value=' . '["top-bar"]' . '>
		<span class="label">' . __('Header Menu Style', 'themify') . '</span>
		<select name="'.$prefix.'menu_style">' .
			themify_options_module($menu_style_options, $prefix.'menu_style') . '
		</select>
	</p>';
	return $output;	
}
}

if( ! function_exists( 'themify_footer_design' ) ) {
/**
 * Footer Design
 * @return string
 */
function themify_footer_design() {

	/**
		* Footer Design
		*/
	$html = '<p>
					<span class="label">' . __( 'Footer Design', 'themify' ) . '</span>';
	
	// Exclusions

	$key = 'setting-exclude_';

	/**
		* Exclude Site Logo
		*/
	$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
		$key . 'footer_site_logo',
		checked( themify_get( $key . 'footer_site_logo' ), 'on', false ),
		__('Exclude Site Logo.', 'themify')
	);

	/**
		* Exclude Footer Widgets
		*/
	$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
		$key . 'footer_widgets',
		checked( themify_get( $key . 'footer_widgets' ), 'on', false ),
		__('Exclude Footer Widgets.', 'themify')
	);

	/**
	 * Exclude Menu Navigation
	 */
	$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
		$key . 'footer_menu_navigation',
		checked( themify_get( $key . 'footer_menu_navigation' ), 'on', false ),
		__('Exclude Menu Navigation.', 'themify')
	);

	/**
		* Exclude Footer Texts
		*/
	$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
		$key . 'footer_texts',
		checked( themify_get( $key . 'footer_texts' ), 'on', false ),
		__('Exclude Footer Text', 'themify')
	);

	/**
		* Exclude Footer Back to Top
		*/
	$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
		$key . 'footer_back',
		checked( themify_get( $key . 'footer_back' ), 'on', false ),
		__('Exclude Back to Top button', 'themify')
	);

	$options = array(
		array(
			'value' => 'footerwidget-4col',
			'img' => 'themify/img/sidebars/4col.png',
			'title' => __('Widgets 4 Columns', 'themify')),
		array(
			'value' => 'footerwidget-3col',
			'img' => 'themify/img/sidebars/3col.png',
			'title' => __('Widgets 3 Columns', 'themify'),
			'selected' => true),
		array(
			'value' => 'footerwidget-2col',
			'img' => 'themify/img/sidebars/2col.png',
			'title' => __('Widgets 2 Columns', 'themify')),
		array(
			'value' => 'footerwidget-1col',
			'img' => 'themify/img/sidebars/1col.png',
			'title' => __('Widgets 1 Column', 'themify')),
		array(
			'value' => 'none',
			'img' => 'themify/img/sidebars/none.png',
			'title' => __('No Widgets', 'themify'))
	);
	$val = themify_get( 'setting-footer_widgets' );
		
	$html .= '<p class="hide-if none" data-show-if-element="[name=setting-exclude_footer_widgets]" data-show-if-value="false"><span class="label">' . __( 'Footer Widgets', 'themify' ) . '</span>';

	foreach($options as $option){
		if(('' == $val || !$val || !isset($val)) && isset($option['selected']) && $option['selected']){ 
			$val = $option['value'];
		}
		if($val == $option['value']){ 
			$class = 'selected';
		} else {
			$class = '';
		}
		$html .= '<a href="#" class="' . esc_attr( 'preview-icon ' . $class ) . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . esc_url( THEME_URI.'/'.$option['img'] ) . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
	}
	$html .= '<input type="hidden" name="setting-footer_widgets" class="val" value="' . esc_attr( $val ) . '" />';

	$html .= '</p>';
		
	return $html;
}
}